package gov.va.med.mhv.phr.backing;


import java.util.Collection;
import java.util.Iterator;

import gov.va.med.mhv.core.util.Precondition;
import gov.va.med.mhv.core.util.ServiceResponseUtils;
import gov.va.med.mhv.phr.util.AccessFeatureValueUtils;
import gov.va.med.mhv.phr.util.SessionManagement;
import gov.va.med.mhv.usermgmt.service.AccessControlCollectionServiceResponse;
import gov.va.med.mhv.usermgmt.service.delegate.ServiceDelegateFactory;
import gov.va.med.mhv.usermgmt.service.delegate.InPersonAuthenticationServiceDelegate;
import gov.va.med.mhv.usermgmt.transfer.AccessControl;
import gov.va.med.mhv.usermgmt.util.AccessControlUtils;
import gov.va.med.mhv.usermgmt.util.AccessDomainUtils;
import gov.va.med.mhv.usermgmt.util.AccessPermissionUtils;

import gov.va.med.mhv.usermgmt.transfer.Patient;
import gov.va.med.mhv.usermgmt.service.PatientServiceResponse;
import gov.va.med.mhv.usermgmt.transfer.UserProfile;
import gov.va.med.mhv.usermgmt.service.delegate.UserProfileServiceDelegate;
import gov.va.med.mhv.usermgmt.service.UserProfileServiceResponse;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.atlas.messages.Message;
import org.tigris.atlas.messages.Messages;

import com.bea.netuix.servlets.controls.content.backing.AbstractJspBacking;
import com.bea.netuix.servlets.controls.page.BookBackingContext;
import com.bea.netuix.servlets.controls.page.PageBackingContext;

public class ExtractFieldTestBacking extends AbstractJspBacking {

    private static final long serialVersionUID = -22260349618PORT4970L;
    private static final Log LOG = LogFactory.getLog(ExtractFieldTestBacking.
    	class);

    private static String CHEMlABS_PAGE_LABEL = "chemistryHematology";
    private static String APPOINTMENT_PAGE_LABEL = "appointments";
    private static String SECUREMESSAGE_PAGE_LABEL = "secureMessaging";
    private static String WELLNESSREMINDER_PAGE_LABEL = "wellnessReminders";
    private static String MYGOALS_PAGE_LABEL = "myGoalsHome";
	private static String ALLERGIES_PAGE_LABEL = "allergy";
	private static String VBH_PAGE_LABEL = "vbhhandbook";
    private static String MYMEDS_PAGE_LABEL = "myMedsHome";

	private UserProfile userProfile = null;
	public Boolean isPatientIPAed = null;

    public void init(HttpServletRequest request, HttpServletResponse response) {
        Precondition.assertNotNull("request", request);
        if (request.getUserPrincipal() == null) {
         	// Must set "values checked" only AFTER a user has logged in
        	// Values cannot be checked when the session has no user
        	SessionManagement.getInstance().setVisibilityValuesChecked(request,
        		false);
        	if (LOG.isDebugEnabled()) {
        		LOG.debug("Portlet access control not yet performed, "
        				+ "because session has no user.");
        	}
            return;
        }
        final String userName = request.getUserPrincipal().getName();
        if (SessionManagement.getInstance().hasVisibilityValuesChecked(
        	request))
        {
        	if (LOG.isDebugEnabled()) {
        		LOG.debug("Already checked portlet access control for '" +
        			userName + "'");
        	}
     	    return;
        }

        Precondition.assertNotNull("userName", userName);
        AccessControlCollectionServiceResponse accessResponse =
            ServiceDelegateFactory.createAccessControlServiceDelegate().
            findAccessControls(userName);
        if (ServiceResponseUtils.hasErrorMessages(accessResponse)) {
        	Messages messages = accessResponse.getMessages();
			Collection errors = messages.getErrorMessages();
			if (errors.size() > 0) {
				for (Iterator i = errors.iterator(); i.hasNext();) {
					Message message = (Message) i.next();
					LOG.error("***** ServiceResponseUtils.hasErrorMessages: " + message);
				}
			}
            LOG.error("Failed to check portlet access control for '" +
        		userName + "'. Disallowing access for entire session.");
            disallowAccess(request);
            ServiceResponseUtils.logMessages(accessResponse, AccessControl.
         		class, LOG);
        }


        setAccess(request, hasAppointmentsAccess(accessResponse),
        	hasChemLabsAccess(accessResponse),
        	hasWellnessRemindersAccess(accessResponse),
        	hasSecureMessagingAccess(accessResponse),
			hasMyGoalsAccess(accessResponse),
			hasAllergyAccess(accessResponse),
			getIsIPAedUser(userName),
			hasHraAccess(accessResponse),
			hasMyMedsAccess(accessResponse));
    }


	public boolean getIsIPAedUser(String userName) {
		if(isPatientIPAed == null) {
			PatientServiceResponse pResponse = ServiceDelegateFactory.createPatientServiceDelegate().getPatientForUser(getCurrentUserProfile(userName));
			InPersonAuthenticationServiceDelegate delegate = ServiceDelegateFactory.createInPersonAuthenticationServiceDelegate();
			Patient patient = pResponse.getPatient();
	 		if (patient != null) {
	 			isPatientIPAed = delegate.isPatientAuthenticated(patient.getId()).getBoolean();
			} else {
				isPatientIPAed = Boolean.FALSE;
			}
		}

		System.out.println("The value for isPatientIPAed is 1::"+isPatientIPAed);
		return isPatientIPAed;
	}

	/*
	public boolean getIsPatientIPAed() {
		if (isPatientIPAed == null) {
		System.out.println("The value for isPatientIPAed is 2::"+isPatientIPAed);
			return getIsIPAedUser();
		}
		else {
			System.out.println("The value for isPatientIPAed is 3::"+isPatientIPAed);
			return isPatientIPAed;
		}
	}
	*/

	protected final UserProfile getCurrentUserProfile(String userName) {
		if( userProfile == null ) {
			UserProfileServiceDelegate delegate = gov.va.med.mhv.usermgmt.service.delegate.ServiceDelegateFactory.createUserProfileServiceDelegate();
			UserProfileServiceResponse response = delegate.getProfileForUser(userName);
			//UserProfileServiceResponse response = delegate.getProfileForUser(getCurrentUserName());
			userProfile = response.getUserProfile();
		}
		return userProfile;
	}


    public boolean handlePostbackData(HttpServletRequest request,
        HttpServletResponse response)
    {
    	Precondition.assertNotNull("request", request);
        BookBackingContext bookContext = BookBackingContext.
        	getBookBackingContext(request);
        if (bookContext != null) {
	        setPageVisibility(bookContext, APPOINTMENT_PAGE_LABEL,
	        	SessionManagement.getInstance().isAppointmentsVisible(request));
	        setPageVisibility(bookContext, CHEMlABS_PAGE_LABEL,
		        	SessionManagement.getInstance().isChemLabsVisible(request));
	        setPageVisibility(bookContext, ALLERGIES_PAGE_LABEL,
		        	SessionManagement.getInstance().isAllergyVisible(request));
	        setPageVisibility(bookContext, VBH_PAGE_LABEL,SessionManagement.getInstance().isVbhHandbookVisible(request));
	        setPageVisibility(bookContext, WELLNESSREMINDER_PAGE_LABEL,
	        	SessionManagement.getInstance().isWellnessRemindersVisible(
	        	request));
	        // TODO - Secure Messaging should be handled elsewhere
	        setPageVisibility(bookContext, SECUREMESSAGE_PAGE_LABEL,
		        	SessionManagement.getInstance().isSecureMessagingVisible(
		        	request));
			// For MRP MyGoals National release - forcing page label to show
			setPageVisibility(bookContext, MYGOALS_PAGE_LABEL, true);

			setPageVisibility(bookContext, MYMEDS_PAGE_LABEL,
					SessionManagement.getInstance().isMyMedsVisible(request));
        }
        return true;
    }


    private void disallowAccess(HttpServletRequest request) {
        setAccess(request, false, false, false, false, false, false, false, false, false);
    }


    private void setAccess(HttpServletRequest request,
    	boolean hasAppointmentsAccess, boolean hasChemLabsAccess,
    	boolean hasWellnessRemindersAccess, boolean hasSecureMessagingAccess,
    	boolean hasMyGoalsAccess, boolean hasAllergyAccess, boolean hasVbhHandbookAccess, boolean hasHraAccess, boolean hasMyMedsAccess)
    {
        SessionManagement.getInstance().setAppointmentsVisible(request,
        	hasAppointmentsAccess);
        SessionManagement.getInstance().setChemLabsVisible(request,
        	hasChemLabsAccess);
        SessionManagement.getInstance().setWellnessRemindersVisible(request,
        	hasWellnessRemindersAccess);
        // TODO - Secure Messaging should be handled elsewhere
        SessionManagement.getInstance().setSecureMessagingVisible(request,
        	hasSecureMessagingAccess);
        SessionManagement.getInstance().setMyGoalsVisible(request,
        	hasMyGoalsAccess);
        SessionManagement.getInstance().setAllergyVisible(request,
        	hasAllergyAccess);
        SessionManagement.getInstance().setVbhHandbookVisible(request,
        	hasVbhHandbookAccess);
        SessionManagement.getInstance().setHraVisible(request,
                	hasHraAccess);
        SessionManagement.getInstance().setMyMedsVisible(request,
                	hasMyMedsAccess);

        SessionManagement.getInstance().setVisibilityValuesChecked(request,
            true);
    }

    private void setPageVisibility(BookBackingContext bookContext,
    	String pageDefinitionLabel, boolean isVisible)
    {
    	PageBackingContext pageContext = bookContext.
       		getPageBackingContextByDefinitionLabel(pageDefinitionLabel);
        if ((pageContext != null)) {
            pageContext.setVisible(isVisible);
            pageContext.setHidden(!isVisible);
       }
    }

   /**
    * Determine if the user in the session is a Field test patient
    * @param request The request to obtain the session from
    * @return True if the user in the session is a Field test patient;
    * false otherwise.
    */

   @SuppressWarnings("unchecked")
    private boolean hasChemLabsAccess(
    	AccessControlCollectionServiceResponse response)
    {
        Precondition.assertNotNull("response", response);
        return AccessControlUtils.hasAccess(AccessDomainUtils.PHR,
        	AccessFeatureValueUtils.CHEMISTRYHEMATOLOGY.getName(),
            AccessPermissionUtils.READ,
            response.getAccessControls()); // "unchecked"
    }

   @SuppressWarnings("unchecked")
   private boolean hasAllergyAccess(
   	AccessControlCollectionServiceResponse response)
   {
       Precondition.assertNotNull("response", response);
       return AccessControlUtils.hasAccess(AccessDomainUtils.PHR,
       	AccessFeatureValueUtils.ALLERGY.getName(),
           AccessPermissionUtils.READ,
           response.getAccessControls()); // "unchecked"
   }

   @SuppressWarnings("unchecked")
   private boolean hasVbhHandbookAccess(
   	AccessControlCollectionServiceResponse response)
   {
       Precondition.assertNotNull("response", response);
       return AccessControlUtils.hasAccess(AccessDomainUtils.PHR,
       	AccessFeatureValueUtils.VBHHANDBOOK.getName(),
           AccessPermissionUtils.READ,
           response.getAccessControls()); // "unchecked"
   }

    @SuppressWarnings("unchecked")
    private boolean hasAppointmentsAccess(
    	AccessControlCollectionServiceResponse response)
    {
        Precondition.assertNotNull("response", response);
        return AccessControlUtils.hasAccess(AccessDomainUtils.PHR,
        	AccessFeatureValueUtils.APPOINTMENTS.getName(),
            AccessPermissionUtils.READ,
            response.getAccessControls()); // "unchecked"
    }

    @SuppressWarnings("unchecked")
    private boolean hasWellnessRemindersAccess(
    	AccessControlCollectionServiceResponse response)
    {
        Precondition.assertNotNull("response", response);
        return AccessControlUtils.hasAccess(AccessDomainUtils.PHR,
        	AccessFeatureValueUtils.WELLNESSREMINDERS.getName(),
            AccessPermissionUtils.READ,
            response.getAccessControls()); // "unchecked"
    }

    @SuppressWarnings("unchecked")
    private boolean hasSecureMessagingAccess(
    	AccessControlCollectionServiceResponse response)
    {
        Precondition.assertNotNull("response", response);
        return AccessControlUtils.hasAccess(AccessDomainUtils.SM,
        	AccessFeatureValueUtils.SECUREMESSAGING.getName(),
            AccessPermissionUtils.READ,
            response.getAccessControls()); // "unchecked"
    }

    @SuppressWarnings("unchecked")
    private boolean hasMyGoalsAccess(
    	AccessControlCollectionServiceResponse response)
    {
        Precondition.assertNotNull("response", response);
        LOG.debug("AccessDomainUtils.MYGOALS: " + AccessDomainUtils.MYGOALS);
        LOG.debug("AccessFeatureValueUtils.MYGOALS.getName(): " + AccessFeatureValueUtils.MYGOALS.getName());
        LOG.debug("response.getAccessControls(): " + response.getAccessControls());

        return AccessControlUtils.hasAccess(AccessDomainUtils.MYGOALS,
        	AccessFeatureValueUtils.MYGOALS.getName(),
            AccessPermissionUtils.READ,
            response.getAccessControls()); // "unchecked"
    }

    @SuppressWarnings("unchecked")
    private boolean hasHraAccess(
    	AccessControlCollectionServiceResponse response)
    {
        Precondition.assertNotNull("response", response);
        return AccessControlUtils.hasAccess(AccessDomainUtils.PHR,
            	AccessFeatureValueUtils.VAHRA.getName(),
                AccessPermissionUtils.READ,
                response.getAccessControls()); // "unchecked"

    }

    @SuppressWarnings("unchecked")
	    private boolean hasMyMedsAccess(
	    	AccessControlCollectionServiceResponse response)
	    {
	        Precondition.assertNotNull("response", response);
	        return AccessControlUtils.hasAccess(AccessDomainUtils.PHR,
	            	AccessFeatureValueUtils.MYMEDS.getName(),
	                AccessPermissionUtils.READ,
	                response.getAccessControls()); // "unchecked"

    }

}
